<?php
/*--------------------------------------------------------------------------------------------------
    ReservedQuantity.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */
namespace Gambio\Shop\SellingUnit\Unit\ValueObjects;


use Gambio\Shop\ProductModifiers\Modifiers\ValueObjects\ModifierIdentifierInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Interfaces\QuantityInterface;

class ReservedQuantity implements QuantityInterface
{

    /**
     * @param ModifierIdentifierInterface $id
     * @return ModifierQuantityInterface|null
     */
    public function byModifier(ModifierIdentifierInterface $id): ?ModifierQuantityInterface
    {
        $result = null;
        foreach($this->quantities as $quantity){
            foreach($quantity->linkedModifiers() as $linkedModifier){
                if($id->equals($linkedModifier))
                    return $quantity;
            }
        }
        return null;
    }

    /**
     * @var ModifierQuantityInterface[]
     */
    protected $quantities = [];

    /**
     * @param ModifierQuantityInterface $quantity
     */
    public function addReserve(ModifierQuantityInterface $quantity): void
    {
        if (count($this->quantities) && $this->quantities[0]->measureUnit() !== $quantity->measureUnit()) {
            throw new \InvalidArgumentException('Invalid measure unit: ' . $quantity->measureUnit());
        }
        $this->quantities[] = $quantity;
    }

    /**
     * @inheritDoc
     */
    public function measureUnit(): string
    {
        return count($this->quantities) ? $this->quantities[0]->measureUnit() : '';
    }

    /**
     * @inheritDoc
     */
    public function value(): float
    {
        $result = count($this->quantities) ? 50000 : 0;
        foreach ($this->quantities as $quantity) {
            if ($result > $quantity->value()) {
                $result = $quantity->value();
            }
        }
        return $result;
    }
}